<?php

namespace App\Http\Controllers;

use App\Models\Models\Group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
        $created_by = $user->get_created_by();
        $groups = Group::where('created_by', $created_by)->get();
        return view('group.index',compact('groups'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('group.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = Auth::user();
        $created_by = $user->get_created_by();

        $group = new Group();
        $group->name         = $request->name;
        $group->created_by   = $created_by;
        $group->save();
        return redirect()->back()->with('success', __('Group Add Successfully'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\group  $group
     * @return \Illuminate\Http\Response
     */
    public function show(group $group)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\group  $group
     * @return \Illuminate\Http\Response
     */
    public function edit(group $group)
    {
        return view('group.edit',compact('group'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\group  $group
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, group $group)
    {
        $user = Auth::user();
        $created_by = $user->get_created_by();
        $group['name']         = $request->input('name');
        $group['created_by']   = $created_by;
        $group->save();
        return redirect()->back()->with('success', __('Group Update Successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\group  $group
     * @return \Illuminate\Http\Response
     */
    public function destroy(group $group)
    {
        //
        $group->delete();
        return redirect()->back()->with('success', __('Delete Succsefully'));
    }
}
