{{ Form::open(['url' => 'employees', 'enctype' => 'multipart/form-data']) }}
    <div class="form-group">
        <div class="row">
            <div class="col-6">
                {{ Form::label('', __('First Name'), ['class' => 'form-label']) }}
                {{ Form::text('first_name', null, ['class' => 'form-control', 'required' => '']) }}
            </div>
            <div class="col-6">
                {{ Form::label('', __('Last Name'), ['class' => 'form-label']) }}
                {{ Form::text('last_name', null, ['class' => 'form-control', 'required' => '']) }}
            </div>
        </div>
    </div>
    <div class="form-group">
        {{ Form::label('', __('Email'), ['class' => 'form-label']) }}
        {{ Form::email('email', null, ['class' => 'form-control', 'required' => '']) }}
    </div>
    <div class="form-group">
        {{ Form::label('', __('Employee Role'), ['class' => 'form-label']) }}
        {{ Form::select('role_id[]', $role_select,null, ['class' => 'form-control multi-select', 'id'=>'choices-multiple' ,'multiple'=>'','required'=>false]) }}
    </div>
    <div class="form-group">
        {{ Form::label('', __('Location'), ['class' => 'form-label']) }}
        {!! Form::select('location_id[]', $location_select, null, ['required' => false, 'multiple' => 'multiple', 'id'=>'choices-multiple-location_id' ,'class'=> 'form-control multi-select']) !!}
    </div>

    <div class="form-check login form-switch p-0">
        <label class="fcol-form-label f-w-600 pl-1 ms-2" for="user_disable">{{ __('Login enable') }}</label>
        <input type="hidden" name="user_disable" value="off" />
        <input type="checkbox" class="form-check-input ms-1" id="user_disable" name="user_disable" />
    </div>

    <div class="form-group col-md-6 ps_div d-none">
        {{ Form::label('password', __('Password'), ['class' => 'col-form-label']) }}<br>
        {{ Form::password('password', ['class' => 'form-control', 'placeholder' => __('Enter new Password')]) }}
    </div>
    <div class="modal-footer border-0 p-0">
        <button type="button" class="btn  btn-light" data-bs-dismiss="modal">{{ __('Close') }}</button>
        <button type="submit" class="btn  btn-primary">{{ __('Create') }}</button>
    </div>
{{ Form::close() }}

<script>
    $(document).on("click", '#user_disable', function(e) {
        if ($(this).is(':checked')) {
            $('.ps_div').removeClass('d-none');
            $('#password').attr("required", true);
        } else {
            $('.ps_div').addClass('d-none');
            $('#password').val(null);
            $('#password').removeAttr("required");
        }
    });
</script>
