<!doctype html>

@php
    $logo = \App\Models\Utility::get_file('uploads/logo/');
    $company_favicon = Utility::getValByName('company_favicon');
    $setting = \App\Models\Utility::settings();

    $setting = App\Models\Utility::colorset();
    $darklayout = Utility::getValByName('cust_darklayout');

    $setting = \App\Models\Utility::settings();
    $Color = !empty($setting['color']) ? $setting['color'] : 'theme-3';

    if (isset($setting['color_flag']) && $setting['color_flag'] == 'true') {
        $themeColor = 'custom-color';
    } else {
        $themeColor = $Color;
    }
    if (app()->getLocale() == 'ar' || app()->getLocale() == 'he') {
        $SITE_RTL = 'on';
    } else {
        $SITE_RTL = Utility::getValByName('SITE_RTL');
    }

    $lang = \App::getLocale('lang');
    if ($lang == 'ar' || $lang == 'he') {
        $setting['SITE_RTL'] = 'on';
    }
@endphp
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ $SITE_RTL == 'on' ? 'rtl' : '' }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>
        {{ Utility::getValByName('title_text') ? Utility::getValByName('title_text') : config('app.name', 'RotaGo SaaS') }}
        - @yield('page-title') </title>
    <link rel="icon" href="{{ $logo . (isset($favicon) && !empty($favicon) ? $favicon : 'favicon.png') }}"
        type="image/x-icon" />
    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <!-- <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}" id="main-style-link"> -->
    <link rel="stylesheet" href="{{ asset('assets/css/customizer.css') }}">
    <style>
        :root {
            --color-customColor: <?=$Color ?>;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('css/custom-color.css') }}">



    @if ($darklayout == 'on')
        <link rel="stylesheet" href="{{ asset('assets/css/style-dark.css') }}">
    @else
        @if (isset($setting['SITE_RTL']) && $setting['SITE_RTL'] == 'on')
            <link rel="stylesheet" href="{{ asset('assets/css/style-rtl.css') }}" id="main-style-link">
        @else
            <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}" id="main-style-link">
        @endif
    @endif

    @if (isset($setting['SITE_RTL']) && $setting['SITE_RTL'] == 'on')
        <link rel="stylesheet" href="{{ asset('assets/css/custom-auth-rtl.css') }}" id="main-style-link">
    @else
        <link rel="stylesheet" href="{{ asset('assets/css/custom-auth.css') }}" id="main-style-link">
    @endif
    @if ($darklayout == 'on')
        <link rel="stylesheet" href="{{ asset('assets/css/custom-auth-dark.css') }}" id="main-style-link">
    @endif

    <style>
        [dir="rtl"] .dash-sidebar {
            left: auto !important;
        }

        /* [dir="rtl"] .dash-header {
            left: 0;
            right: 280px;
        } */

        [dir="rtl"] .dash-header:not(.transprent-bg) .header-wrapper {
            padding: 0 0 0 30px;
        }

        [dir="rtl"] .dash-header:not(.transprent-bg):not(.dash-mob-header)~.dash-container {
            margin-left: 0px;
        }

        [dir="rtl"] .me-auto.dash-mob-drp {
            margin-right: 10px !important;
        }

        [dir="rtl"] .me-auto {
            margin-left: 10px !important;
        }
    </style>

    <style>
        .language_option_bg option {
            background-color: #fff;
            color: #000;
        }
    </style>

</head>

<body class="{{ $themeColor }}">
    <!-- [ auth-signup ] start -->
    <div class="custom-login">
        <div class="login-bg-img">
            <img src="{{ asset('assets/images/auth/user1.svg') }}" class="login-bg-1">
            <img src="{{ asset('assets/images/auth/user2.svg') }}" class="login-bg-2">
        </div>
        <div class="bg-login bg-primary"></div>
        <div class="custom-login-inner">
            <nav class="navbar navbar-expand-md default">
                <div class="container-fluid pe-2">
                    <a class="navbar-brand" href="#">
                        @if (!empty($darklayout) && $darklayout == 'on')
                            <img src="{{ $logo . '/' . (isset($company_logo) && !empty($company_logo) ? $company_logo . '?timestemp=' . time() : 'logo-light.png') }}"
                                class="logo" alt="logo" style="height=30px ; width: 135px !important;">
                        @else
                            <img src="{{ $logo . (isset($company_logos) && !empty($company_logo) ? $company_logo . '?timestemp=' . time() : 'logo-dark.png') }}"
                                class="logo" alt="logo" style="height=30px ; width: 135px !important;">
                        @endif
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarlogin">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarlogin">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item">
                                @include('landingpage::layouts.buttons')
                            </li>
                            @yield('lang-selectbox')

                        </ul>
                    </div>
                </div>
            </nav>
            <main class="custom-wrapper">
                <div class="custom-row">
                    <div class="card">
                        @yield('content')
                    </div>
                </div>
            </main>
            <footer>
                <div class="auth-footer mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <span>&copy;
                                    {{ App\Models\Utility::getValByName('footer_text') ? App\Models\Utility::getValByName('footer_text') : config('app.name', 'Rotago ') }}
                                    {{ date('Y') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    <!-- [ auth-signup ] end -->

    <!-- Scripts -->
    <script src="{{ asset('custom/libs/jquery/dist/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/js/vendor-all.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/plugins/feather.min.js') }}"></script>
    <script>
        feather.replace();
    </script>
    @stack('custom-scripts')
    @if (isset($settings['cookie_consent']) && $settings['cookie_consent'] == 'on')
        @include('layouts.cookie_consent')
    @endif
    @stack('pagescript')

    @if (\Session::has('success'))
        <script>
            show_toastr('{{ __('Success') }}', '{!! session('success') !!}', 'success');
        </script>
        {{ Session::forget('success') }}
    @endif

    @if (Session::has('error'))
        <script>
            show_toastr('{{ __('Error') }}', '{!! session('error') !!}', 'error');
        </script>
        {{ Session::forget('error') }}
    @endif

</body>

</html>
