<!doctype html>

<?php
    $logo = \App\Models\Utility::get_file('uploads/logo/');
    $company_favicon = Utility::getValByName('company_favicon');
    $setting = \App\Models\Utility::settings();

    $setting = App\Models\Utility::colorset();
    $darklayout = Utility::getValByName('cust_darklayout');

    $setting = \App\Models\Utility::settings();
    $Color = !empty($setting['color']) ? $setting['color'] : 'theme-3';

    if (isset($setting['color_flag']) && $setting['color_flag'] == 'true') {
        $themeColor = 'custom-color';
    } else {
        $themeColor = $Color;
    }
    if (app()->getLocale() == 'ar' || app()->getLocale() == 'he') {
        $SITE_RTL = 'on';
    } else {
        $SITE_RTL = Utility::getValByName('SITE_RTL');
    }

    $lang = \App::getLocale('lang');
    if ($lang == 'ar' || $lang == 'he') {
        $setting['SITE_RTL'] = 'on';
    }
?>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e($SITE_RTL == 'on' ? 'rtl' : ''); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>
        <?php echo e(Utility::getValByName('title_text') ? Utility::getValByName('title_text') : config('app.name', 'RotaGo SaaS')); ?>

        - <?php echo $__env->yieldContent('page-title'); ?> </title>
    <link rel="icon" href="<?php echo e($logo . (isset($favicon) && !empty($favicon) ? $favicon : 'favicon.png')); ?>"
        type="image/x-icon" />
    <!-- Scripts -->
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <!-- <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>" id="main-style-link"> -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/customizer.css')); ?>">
    <style>
        :root {
            --color-customColor: <?=$Color ?>;
        }
    </style>
    <link rel="stylesheet" href="<?php echo e(asset('css/custom-color.css')); ?>">



    <?php if($darklayout == 'on'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/style-dark.css')); ?>">
    <?php else: ?>
        <?php if(isset($setting['SITE_RTL']) && $setting['SITE_RTL'] == 'on'): ?>
            <link rel="stylesheet" href="<?php echo e(asset('assets/css/style-rtl.css')); ?>" id="main-style-link">
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>" id="main-style-link">
        <?php endif; ?>
    <?php endif; ?>

    <?php if(isset($setting['SITE_RTL']) && $setting['SITE_RTL'] == 'on'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-auth-rtl.css')); ?>" id="main-style-link">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-auth.css')); ?>" id="main-style-link">
    <?php endif; ?>
    <?php if($darklayout == 'on'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-auth-dark.css')); ?>" id="main-style-link">
    <?php endif; ?>

    <style>
        [dir="rtl"] .dash-sidebar {
            left: auto !important;
        }

        /* [dir="rtl"] .dash-header {
            left: 0;
            right: 280px;
        } */

        [dir="rtl"] .dash-header:not(.transprent-bg) .header-wrapper {
            padding: 0 0 0 30px;
        }

        [dir="rtl"] .dash-header:not(.transprent-bg):not(.dash-mob-header)~.dash-container {
            margin-left: 0px;
        }

        [dir="rtl"] .me-auto.dash-mob-drp {
            margin-right: 10px !important;
        }

        [dir="rtl"] .me-auto {
            margin-left: 10px !important;
        }
    </style>

    <style>
        .language_option_bg option {
            background-color: #fff;
            color: #000;
        }
    </style>

</head>

<body class="<?php echo e($themeColor); ?>">
    <!-- [ auth-signup ] start -->
    <div class="custom-login">
        <div class="login-bg-img">
            <img src="<?php echo e(asset('assets/images/auth/user1.svg')); ?>" class="login-bg-1">
            <img src="<?php echo e(asset('assets/images/auth/user2.svg')); ?>" class="login-bg-2">
        </div>
        <div class="bg-login bg-primary"></div>
        <div class="custom-login-inner">
            <nav class="navbar navbar-expand-md default">
                <div class="container-fluid pe-2">
                    <a class="navbar-brand" href="#">
                        <?php if(!empty($darklayout) && $darklayout == 'on'): ?>
                            <img src="<?php echo e($logo . '/' . (isset($company_logo) && !empty($company_logo) ? $company_logo . '?timestemp=' . time() : 'logo-light.png')); ?>"
                                class="logo" alt="logo" style="height=30px ; width: 135px !important;">
                        <?php else: ?>
                            <img src="<?php echo e($logo . (isset($company_logos) && !empty($company_logo) ? $company_logo . '?timestemp=' . time() : 'logo-dark.png')); ?>"
                                class="logo" alt="logo" style="height=30px ; width: 135px !important;">
                        <?php endif; ?>
                    </a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarlogin">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarlogin">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item">
                                <?php echo $__env->make('landingpage::layouts.buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </li>
                            <?php echo $__env->yieldContent('lang-selectbox'); ?>

                        </ul>
                    </div>
                </div>
            </nav>
            <main class="custom-wrapper">
                <div class="custom-row">
                    <div class="card">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </main>
            <footer>
                <div class="auth-footer mt-5">
                    <div class="container">
                        <div class="row">
                            <div class="col-12">
                                <span>&copy;
                                    <?php echo e(App\Models\Utility::getValByName('footer_text') ? App\Models\Utility::getValByName('footer_text') : config('app.name', 'Rotago ')); ?>

                                    <?php echo e(date('Y')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    <!-- [ auth-signup ] end -->

    <!-- Scripts -->
    <script src="<?php echo e(asset('custom/libs/jquery/dist/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vendor-all.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/feather.min.js')); ?>"></script>
    <script>
        feather.replace();
    </script>
    <?php echo $__env->yieldPushContent('custom-scripts'); ?>
    <?php if(isset($settings['cookie_consent']) && $settings['cookie_consent'] == 'on'): ?>
        <?php echo $__env->make('layouts.cookie_consent', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <?php echo $__env->yieldPushContent('pagescript'); ?>

    <?php if(\Session::has('success')): ?>
        <script>
            show_toastr('<?php echo e(__('Success')); ?>', '<?php echo session('success'); ?>', 'success');
        </script>
        <?php echo e(Session::forget('success')); ?>

    <?php endif; ?>

    <?php if(Session::has('error')): ?>
        <script>
            show_toastr('<?php echo e(__('Error')); ?>', '<?php echo session('error'); ?>', 'error');
        </script>
        <?php echo e(Session::forget('error')); ?>

    <?php endif; ?>

</body>

</html>
<?php /**PATH /var/www/html/product/rotago/main_file/resources/views/layouts/auth.blade.php ENDPATH**/ ?>